//---------------------------------------------------------------
// Fichero:  ortoedro.asy
// Objetivo: Mostrar un ortoedro
// Fecha:    V.11.3.2022
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Geometría 3D
import three;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(4cm);

// Punto de proyección
currentprojection=orthographic(7,4,3);

// Punto de luz
currentlight=light(10,0,10);

// La base
triple A=(0,0,0), B=(3,0,0), C=(3,5,0), D=(0,5,0);

// El techo
triple E1=(0,0,2), F=(3,0,2), G=(3,5,2), H=(0,5,2);

// Las caras del poliedro
path3[] Caras={A--B--C--D--cycle,
               A--B--F--E1--cycle,
               B--C--G--F--cycle,
               E1--A--B--F--cycle,
               E1--H--G--F--cycle,
               D--C--G--H--cycle,
               };

// Dibujamos las caras
draw(surface(Caras),lightgray+opacity(.7));

// Dibujamos las aristas
draw(Caras,1.5bp+black);

// Dibujamos una diagonal
draw(B--H,2bp+red);

// Dibujamos la diagonal de una cara
draw(B--D,2bp+deepgreen);

// Nombramos los vértices que necesitamos
pen FormatoTexto=fontsize(8pt)+Helvetica(series="m",shape="n");
label("A",B,W,FormatoTexto);
label("B",C,S,FormatoTexto);
label("C",D,E,FormatoTexto);
label("D",H,NE,FormatoTexto);
