//---------------------------------------------------------------
// Fichero:  piramide.asy
// Objetivo: Mostrar la pirámide
// Fecha:    L.15.5.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Geometría 3D
import three;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(4cm);

// Punto de proyección
currentprojection=orthographic(5,4,3);

// Punto de luz
currentlight=light(10,0,10);

// La base es un polígono regular
path3 PoligonoBase = path3(polygon(3));

// El vértice superior
triple V=(0,0,2);

// Las caras del poliedro
path3[] Caras={PoligonoBase};
for (int i=0; i<3; ++i)
    { Caras.push(point(PoligonoBase,i)--point(PoligonoBase,i+1)--V--cycle); }

// Dibujamos las caras
draw(surface(Caras),lightgray+opacity(.5));

// Dibujamos las aristas
draw(Caras,1.5bp+black);

// El centro de la base
triple T=(point(PoligonoBase,0)+point(PoligonoBase,1)+point(PoligonoBase,2))/3;

// Dos vértices de la base
triple A=point(PoligonoBase,0);
triple B=point(PoligonoBase,1);

// Punto medio del lado opuesto
triple C=(point(PoligonoBase,1)+point(PoligonoBase,2))/2;

// Marcamos y Nombramos los vértices que necesitamos
pen FormatoTexto=fontsize(8pt)+Helvetica(series="m",shape="n");
dot(V,blue); label("V",V,N,FormatoTexto);
dot(T,blue); label("T",T,NW,FormatoTexto);
dot(A,blue); label("A",A,W,FormatoTexto);
dot(B,blue); label("B",B,E,FormatoTexto);
dot(C,blue); label("C",C,SW,FormatoTexto);

// Alturas
draw(A--C,1bp+blue);
draw(V--T,1bp+blue);
draw(V--C,1bp+blue);

