//---------------------------------------------------------------
// Fichero:  enunciado07.asy
// Objetivo: Dibujar el enunciado 7
// Fecha:    S.17.6.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.8cm);

// Grosor de las líneas
defaultpen(1);

// La figura original
pair V[]={(1,0), (2,0), (2,1), (3,1), (3,2), (2,2), (2,3), (1,3), (1,2), (0,2),
          (0,1), (1,1)};
guide Cruz;
for ( int i=0 ; i<V.length ; ++i )
    { Cruz = Cruz -- V[i]; }
Cruz = Cruz -- cycle;
path Original=rotate(45,(1.5,1.5))*Cruz;

// La transformación
transform F=shift(3,0.75)*scale(.5)*xscale(2);

// La figura nueva
path Nueva=F*Cruz;

// Dibujamos
draw(Original);
draw(Nueva);

