//---------------------------------------------------------------
// Fichero:  enunciado1.asy
// Objetivo: Dibujar el enunciado 1
// Fecha:    M.25.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3.5cm);

// Grosor de las líneas
defaultpen(1);

// Los formatos
pen FormatoLinea=blue+0.2mm;
pen FormatoTexto=black+fontsize(8pt);
pen FormatoPunto=2bp+red;

// Función que devuelve el punto medio de un segmento
pair Med(pair P1, pair P2)
    { return (P1+P2)/2; }

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    {
    real Longitud=(round(10*length(A-B)))/10;
    return replace(string(Longitud),".",",");
    }

// Función que devuelve un vector normal a un segmento
pair Normal(pair P1, pair P2)
    {
    pair Vector=unit(P2-P1);
    return (Vector.y,-Vector.x);
    }

// Función que devuelve el producto escalar de dos vectores
real PE(pair z, pair w)
    { return z.x*w.y-z.y*w.x; }

// Función que da un segmento entre dos puntos opuesto a un tercero
void Segmento(pair A, pair B, pair C, real Ajuste, bool Incognita)
    {
    pair v=Normal(A,B);
    pair D=Med(A,B)+v;
    if ( sgn(PE(A-C,B-C)) == sgn(PE(A-D,B-D)) )
        { v=-v; }
    pair Direccion=B-A;
    draw(A+v+Ajuste*Direccion -- B+v-Ajuste*Direccion,FormatoLinea);
    string Texto=Dist(A,B);
    if ( Incognita ) { Texto="x"; }
    label(Texto,Med(A,B),2v,FormatoTexto);
    }

// El radio de la circunferencia
real R=17.4;

// Los puntos
pair A=R*dir(95), B=R*dir(190), C=R*dir(-30), D=R*dir(42);
pair E=intersectionpoint(A--C,B--D);

// Las líneas
draw(circle((0,0),R));
draw(A -- C);
draw(B -- D);

// Los segmentos
Segmento(A,E,D,0.05,false);
Segmento(B,E,A,0.05,true);
Segmento(D,E,A,0.05,false);
Segmento(C,E,D,0.05,false);

// Los puntos
dot(A,FormatoPunto);
dot(B,FormatoPunto);
dot(C,FormatoPunto);
dot(D,FormatoPunto);
dot(E,FormatoPunto);
