//---------------------------------------------------------------
// Fichero:  papel.asy
// Objetivo: Dibujar tamaños de papel
// Fecha:    V.16.6.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Grosor de las líneas
defaultpen(1);

// Altura del primer rectángulo
real Altura=1;

// Factor para calcular la anchura
real Factor=1/sqrt(2);

// El primer rectángulo
real Anchura=Altura*Factor;
draw(box((0,0),(Anchura,Altura)));
label("A0",(Anchura/2,Altura/2),fontsize(10pt)+blue);

// El segundo rectángulo
transform Mover=shift(Anchura+0.05,0);
Altura=Anchura;
Anchura=Altura*Factor;
draw(Mover*box((0,0),(Anchura,Altura)));
label("A1",Mover*(Anchura/2,Altura/2),fontsize(10pt)+blue);

// El tercer rectángulo
transform Mover=Mover*shift(Anchura+0.05,0);
Altura=Anchura;
Anchura=Altura*Factor;
draw(Mover*box((0,0),(Anchura,Altura)));
label("A2",Mover*(Anchura/2,Altura/2),fontsize(10pt)+blue);

// El cuarto rectángulo
transform Mover=Mover*shift(Anchura+0.05,0);
Altura=Anchura;
Anchura=Altura*Factor;
draw(Mover*box((0,0),(Anchura,Altura)));
label("A3",Mover*(Anchura/2,Altura/2),fontsize(10pt)+blue);
