//---------------------------------------------------------------
// Fichero:  ejemplo1.asy
// Objetivo: Dibujar dos triángulos semejantes
// Fecha:    S.24.6.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(10cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve el punto medio de un segmento
pair Med(pair P1, pair P2)
    { return (P1+P2)/2; }

// Función que devuelve el baricentro de un triángulo
pair Bar(pair P1, pair P2, pair P3)
    { return (P1+P2+P3)/3; }

// Los vértices
pair A1=(0,0), B1=(4,0), C1=(0,3);

// El primer triángulo
path T1 = A1 -- B1 -- C1 -- cycle;
draw(T1);

// El segundo triángulo
transform F=shift(6,0)*scale(1.25);
pair A2=F*A1, B2=F*B1, C2=F*C1;
path T2 = F*T1;
draw(T2);

// Las longitudes de los lados
label("4",Med(A1,B1),S,blue);
label("5",Med(A2,B2),S,blue);
label("5",Med(C1,B1),NE,blue);
label("6,25",Med(C2,B2),NE,blue);
label("3",Med(A1,C1),W,blue);
label("3,75",Med(A2,C2),W,blue);

// Los nombres de los triángulos
label("T",Bar(A1,B1,C1),blue+fontsize(16pt));
label("S",Bar(A2,B2,C2),blue+fontsize(16pt));
