//---------------------------------------------------------------
// Fichero:  paralelas.asy
// Objetivo: Dibujar el teorema de Tales para rectas paralelas
// Fecha:    S.8.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3.5cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve el punto medio de un segmento
pair Med(pair P1, pair P2)
    { return (P1+P2)/2; }

// Función que devuelve un vector normal a un segmento
pair Normal(pair P1, pair P2)
    {
    pair Vector=unit(P2-P1);
    return (Vector.y,-Vector.x);
    }

// La recta de la izquierda
pair A=(0,0), B=(4,9);
path Izq=A -- B;
draw(Izq);

// La recta de la derecha
pair C=(7,0), D=(6,9);
path Der=C -- D;
draw(Der);

// Las rectas paralelas
path r1=(-1,1) -- (8,1);
path r2=(-1,4) -- (8,4);
path r3=(-1,8) -- (8,8);
draw(r1);
draw(r2);
draw(r3);

// Los puntos de corte entre las rectas
pair P1=intersectionpoint(Izq,r1);
pair P2=intersectionpoint(Izq,r2);
pair P3=intersectionpoint(Izq,r3);
pair Q1=intersectionpoint(Der,r1);
pair Q2=intersectionpoint(Der,r2);
pair Q3=intersectionpoint(Der,r3);
pen Formato=2bp+red;
dot(P1,Formato);
dot(P2,Formato);
dot(P3,Formato);
dot(Q1,Formato);
dot(Q2,Formato);
dot(Q3,Formato);

// Las líneas auxiliares
real delta=0.2;
pen Formato=blue+0.2mm;
pair v=-delta*Normal(P2,P3);
pair Direccion=P3-P2;
draw(P2+v+0.03*Direccion -- P3+v-0.05*Direccion,Formato);
pair v=delta*Normal(Q2,Q3);
pair Direccion=Q3-Q2;
draw(Q2+v+0.03*Direccion -- Q3+v-0.05*Direccion,Formato);
pen Formato=deepgreen+0.2mm;
pair v=-delta*Normal(P1,P2);
pair Direccion=P2-P1;
draw(P1+v+0.03*Direccion -- P2+v-0.07*Direccion,Formato);
pair v=delta*Normal(Q1,Q2);
pair Direccion=Q2-Q1;
draw(Q1+v+0.03*Direccion -- Q2+v-0.07*Direccion,Formato);

// Las longitudes de los segmentos
pen Formato=blue+fontsize(10pt);
label("a",Med(P3,P2),2*W,Formato);
label("a'",Med(Q3,Q2),2*E,Formato);
pen Formato=deepgreen+fontsize(10pt);
label("b",Med(P1,P2),2*W,Formato);
label("b'",Med(Q1,Q2),2*E,Formato);
