//---------------------------------------------------------------
// Fichero:  triangulos.asy
// Objetivo: Dibujar dos triángulos en posición de Tales
// Fecha:    S.8.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3.5cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve el punto medio de un segmento
pair Med(pair P1, pair P2)
    { return (P1+P2)/2; }

// Función que devuelve un vector normal a un segmento
pair Normal(pair P1, pair P2)
    {
    pair Vector=unit(P2-P1);
    return (Vector.y,-Vector.x);
    }

// Los cuatro puntos más bajos
pair A=(0,0), B=(9,0), C=(7,2), E1=(0.75,2);

// El quinto punto
pair D=intersectionpoint(A--A+5*(E1-A), B--B+5(C-B));

// Los triángulos
draw(A -- B -- D -- cycle);
draw(E1 -- C);

// Los puntos
pen Formato=2bp+red;
dot(A,2bp+Formato);
dot(B,2bp+Formato);
dot(C,2bp+Formato);
dot(D,2bp+Formato);
dot(E1,2bp+Formato);

// Las líneas auxiliares
real delta=0.2;
pen Formato=heavymagenta+0.2mm;
pair v=delta*Normal(A,B);
draw(A+v -- B+v,Formato);
pair Direccion=C-E1;
draw(E1-v+0.05*Direccion -- C-v-0.1*Direccion,Formato);
pen Formato=blue+0.2mm;
pair v=-delta*Normal(A,D);
draw(A+v -- D+v,Formato);
pair Direccion=D-E1;
draw(E1-v+0.1*Direccion -- D-v-0.1*Direccion,Formato);
pen Formato=deepgreen+0.2mm;
pair v=delta*Normal(B,D);
draw(B+v -- D+v,Formato);
pair Direccion=D-C;
draw(C-v+0.1*Direccion -- D-v-0.075*Direccion,Formato);

// Las longitudes de los lados
pen Formato=blue+fontsize(10pt);
label("a",Med(D,E1),E,Formato);
label("a'",Med(A,D),W,Formato);
pen Formato=deepgreen+fontsize(10pt);
label("b",Med(C,D),SW,Formato);
label("b'",Med(B,D),NE,Formato);
pen Formato=heavymagenta+fontsize(10pt);
label("c",Med(E1,C),N,Formato);
label("c'",Med(A,B),S,Formato);
