//---------------------------------------------------------------
// Fichero:  ejemplo4.asy
// Objetivo: Ilustrar el ejemplo4
// Fecha:    D.16.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.8cm);

// Grosor de las líneas
defaultpen(1);

// Los vértices
pair A=(0,0), B=(4,-3), C=(8,6), D=(2,4), E=(-2,4), F=(-8,6), G=(-4,-3);

// Los triángulos
draw(A -- E, gray);
draw(A -- D, gray);
draw(B -- D, gray);
draw(E -- G, gray);

// El polígono
draw(A -- B -- C -- D -- E -- F -- G -- cycle);

// Los nombres de los triángulos
label("T1", (E+F+G)/3, blue+fontsize(10pt));
label("T2", (A+E+G)/3, blue+fontsize(10pt));
label("T3", (A+D+E)/3, blue+fontsize(10pt));
label("T4", (A+D+B)/3, blue+fontsize(10pt));
label("T5", (C+D+B)/3, blue+fontsize(10pt));
