//---------------------------------------------------------------
// Fichero:  ejemplo1.asy
// Objetivo: Dibujar dos triángulos semejantes
// Fecha:    M.18.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve como cadena el valor redondeado en grados de un ángulo
string Ang(pair P1, pair V, pair P2, int e)
    { return string(round(degrees(P2-V)-degrees(P1-V))+360*e)+"$^\circ$"; }

// Los vértices
pair A1=(0,0), B1=(6,-2), C1=(3,3);

// El primer triángulo
path T1 = A1 -- B1 -- C1 -- cycle;
draw(T1);

// El segundo triángulo
transform F=shift(11,-2)*rotate(50)*scale(1.4);
pair A2=F*A1, B2=F*B1, C2=F*C1;
path T2 = F*T1;
draw(T2);

// Los nombres de los vértices
label("A",A1,W);
label("D",A2,SW);
label("B",B1,SE);
label("E",B2,E);
label("C",C1,N);
label("F",C2,N);

// Los ángulos
markangle(Ang(B1,A1,C1,1), radius=4mm, B1, A1, C1, 0.5bp+blue);
markangle(Ang(B2,A2,C2,0), radius=4mm, B2, A2, C2, 0.5bp+blue);
markangle(Ang(C1,B1,A1,0), radius=5mm, C1, B1, A1, 0.5bp+blue);
markangle(Ang(C2,B2,A2,0), radius=5mm, C2, B2, A2, 0.5bp+blue);
