//---------------------------------------------------------------
// Fichero:  enunciado3.asy
// Objetivo: Dibujar el enunciado 3
// Fecha:    X.19.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve como cadena el valor redondeado en grados de un ángulo
string Ang(pair P1, pair V, pair P2, int e)
    { return string(round(degrees(P2-V)-degrees(P1-V))+360*e)+"$^\circ$"; }

// Función que devuelve el punto medio de un segmento
pair Med(pair P1, pair P2)
    { return (P1+P2)/2; }

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    {
    real Longitud=(round(10*length(A-B)))/10;
    return replace(string(Longitud),".",",");
    }

// Los vértices
pair A1=(0,0), B1=(20,0), C1=(13,-11);

// El primer triángulo
path T1 = A1 -- B1 -- C1 -- cycle;
draw(T1);

// El segundo triángulo
transform F=shift(19,0)*reflect(C1+(0,1),C1-(0,1))*scale(0.9);
pair A2=F*A1, B2=F*B1, C2=F*C1;
path T2 = F*T1;
draw(T2);

// Los ángulos
pen Formato=0.5bp+blue+fontsize(10pt);
markangle(Ang(B1,C1,A1,0), radius=4mm, B1, C1, A1, Formato);
markangle(Ang(A2,C2,B2,0), radius=4mm, A2, C2, B2, Formato);

// Los lados
pen Formato=blue+fontsize(10pt);
label(Dist(A1,B1),Med(A1,B1),N,Formato);
label(Dist(A1,C1),Med(A1,C1),SW,Formato);
label(Dist(B1,C1),Med(B1,C1),SE,Formato);
label("x",Med(A2,B2),N,Formato);
label(Dist(A2,C2),Med(A2,C2),SE,Formato);
label(Dist(B2,C2),Med(B2,C2),SW,Formato);
