//---------------------------------------------------------------
// Fichero:  resolucion1.asy
// Objetivo: Dibujar la resolucion 1
// Fecha:    D.23.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3.5cm);

// Grosor de las líneas
defaultpen(1);

// Los formatos
pen FormatoTexto=black+fontsize(8pt);
pen FormatoPunto=2bp+red;
pen FormatoAngulo=0.5bp+blue+fontsize(6pt);

// Los puntos
pair A=(0,20), B=(0,11), C=(35,2), D=(35,13);
pair E=intersectionpoint(A--C,B--D);

// Los ángulos
markangle("$\alpha$", radius=2mm, B, A, E, FormatoAngulo);
markangle("$\beta$", radius=1mm, E, B, A, FormatoAngulo);
markangle("$\gamma$", radius=4mm, A, E, B, FormatoAngulo);
markangle("$\alpha$'", radius=2mm, D, C, E, FormatoAngulo);
markangle("$\beta$'", radius=1mm, E, D, C, FormatoAngulo);
markangle("$\gamma$'", radius=4mm, C, E, D, FormatoAngulo);

// Las líneas
draw((0,-2)--(0,22));
draw((35,-2)--(35,22));
draw(A -- C);
draw(B -- D);

// Los puntos
dot(A,FormatoPunto);
dot(B,FormatoPunto);
dot(C,FormatoPunto);
dot(D,FormatoPunto);
dot(E,FormatoPunto);
label("A",A,NW,FormatoTexto);
label("B",B,SW,FormatoTexto);
label("C",C,SE,FormatoTexto);
label("D",D,NE,FormatoTexto);
label("E",E,N,FormatoTexto);
