//---------------------------------------------------------------
// Fichero:  ejemplo2.asy
// Objetivo: Dibujar dos triángulos rectángulos semejantes
// Fecha:    V.28.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Los vértices
pair A1=(0,0), B1=(4,0), C1=(0,3);

// El primer triángulo
path T1 = A1 -- B1 -- C1 -- cycle;
draw(T1);

// El segundo triángulo
transform F=shift(6,0)*scale(1.2);
pair A2=F*A1, B2=F*B1, C2=F*C1;
path T2 = F*T1;
draw(T2);

// Los nombres de los vértices
label("A",A1,SW);
label("D",A2,SW);
label("B",B1,SE);
label("E",B2,SE);
label("C",C1,N);
label("F",C2,N);

// Los ángulos
pen FormatoAngulo = 0.5bp+blue;
markrightangle(B1, A1, C1, 4mm, FormatoAngulo);
markrightangle(B2, A2, C2, 4mm, FormatoAngulo);

// Los lados
pen FormatoLado=10pt+blue;
label("4",(2,0),S,FormatoLado);
label("3",(0,1.5),W,FormatoLado);
label("4.8",(8.4,0),S,FormatoLado);
label("3.6",(6,1.8),W,FormatoLado);
