//---------------------------------------------------------------
// Fichero:  altura.asy
// Objetivo: Dibujar un triángulo rectángulo con una altura
// Fecha:    X.30.8.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// Los vértices
pair A=dir(110), B=(-1,0), C=(1,0);

// El punto de corte
pair Q=(A.x,0);

// La altura
draw(A -- Q, blue);

// El triángulo
draw(A -- B -- C -- cycle);

// Los ángulos
pen FormatoAngulo = 0.5bp+blue;
markrightangle(A, Q, B, 4mm, FormatoAngulo);
markrightangle(A, Q, C, 3mm, FormatoAngulo);

// Los segmentos
pen FormatoTexto=10pt+blue;
label("m",(B+Q)/2,S,FormatoTexto);
label("n",(C+Q)/2,S,FormatoTexto);
label("b",(A+C)/2,NE,FormatoTexto);
label("c",(A+B)/2,NW,FormatoTexto);
label("h",(A+Q)/2,SE,FormatoTexto);

// Los puntos
pen FormatoPunto=3bp+red;
dot(A,FormatoPunto);
dot(B,FormatoPunto);
dot(C,FormatoPunto);
dot(Q,FormatoPunto);
label("A", A, N, FormatoTexto);
label("B", B, W, FormatoTexto);
label("C", C, E, FormatoTexto);
label("Q", Q, S, FormatoTexto);
