//---------------------------------------------------------------
// Fichero:  figura2.asy
// Objetivo: Mostrar la figura 2
// Fecha:    L.4.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Geometría 3D
import three;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(4.4cm);

// Punto de proyección
currentprojection=orthographic(5,4,3);

// Punto de luz
currentlight=light(10,0,10);

// Número de vértices de la base
int N=5;

// La base es un polígono regular
path3 PoligonoBase = path3(rotate(5)*polygon(N));

// El vértice superior
triple V=(0,0,2);

// Las caras del poliedro
path3[] Caras={PoligonoBase};
for (int i=0; i<N; ++i)
    { Caras.push(point(PoligonoBase,i)--point(PoligonoBase,i+1)--V--cycle); }

// Creamos un nuevo polígono
guide3 PoligonoNuevo;
for (int i=0; i<N; ++i)
    { PoligonoNuevo = PoligonoNuevo --
                     (point(PoligonoBase,i)+0.5*(V-point(PoligonoBase,i))); }
PoligonoNuevo = PoligonoNuevo -- cycle;
draw(PoligonoNuevo,1bp+red);
draw(surface(PoligonoNuevo));

// Un plano que corta a la pirámide
real Lado=1.5;
real Altura=point(PoligonoNuevo,0).z;
path3 Plano=shift(-Lado/2,-Lado/2,Altura)*scale3(Lado)*unitsquare3;
draw(surface(Plano),red+opacity(.7));
draw(Plano,0.25bp+red);

// Dibujamos las caras
draw(surface(Caras),lightgray+opacity(.7));

// Dibujamos las aristas
draw(Caras,1.5bp+black);
