//---------------------------------------------------------------
// Fichero:  altura-apotemas-2D.asy
// Objetivo: Mostrar en 2D la relación entre la altura y las tres
//           apotemas
// Fecha:    X.6.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,2.2cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(0,2), C=(-1.7,2), D=(-2,0);

// El trapecio
draw(A -- B -- C -- D -- cycle);

// La altura
draw((0,0) -- (0,2));

// Los textos
pen FormatoTexto=fontsize(10pt)+blue;
label("$h$", (A+B)/2, E, FormatoTexto);
label("$b$", (B+C)/2, N, FormatoTexto);
label("$m$", (C+D)/2, W, FormatoTexto);
label("$a$", (D+A)/2, S, FormatoTexto);

// Marcamos los ángulos rectos
markrightangle(A, B, C, 2mm, 0.5bp+blue);
markrightangle(D, A, B, 2mm, 0.5bp+blue);
