//---------------------------------------------------------------
// Fichero:  altura-apotemas-3D.asy
// Objetivo: Mostrar en 3D la relación entre la altura y las tres
//           apotemas
// Fecha:    J.7.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Geometría 3D
import three;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(3.5cm);

// Punto de proyección
currentprojection=orthographic(5,4,2);

// Punto de luz
currentlight=light(10,0,10);

// Número de vértices de las bases
int N=4;

// Altura
real Altura=3;

// Las bases
real r2=sqrt(2);
path3 PoligonoBase1 = path3(rotate(5)*scale(12*r2)*polygon(N));
path3 PoligonoBase2 = shift(Altura*Z)*path3(rotate(5)*scale(8*r2)*polygon(N));

// Las caras del prisma
path3[] Caras={PoligonoBase1, PoligonoBase2};
for (int i=0; i<N; ++i)
    { Caras.push(point(PoligonoBase1,i)--point(PoligonoBase1,i+1)--
      point(PoligonoBase2,i+1)--point(PoligonoBase2,i)--cycle); }

// Dibujamos las caras
draw(surface(Caras),lightgray+opacity(.7));

// Dibujamos las aristas
draw(Caras,1.5bp+black);

// Una apotema del tronco
triple S1=(point(PoligonoBase1,0)+point(PoligonoBase1,1))/2;
triple S2=(point(PoligonoBase2,0)+point(PoligonoBase2,1))/2;
dot(S1, 3bp+black);
dot(S2, 3bp+black);
draw(S1 -- S2, 2bp+red);

// La altura
triple S4=(0,0,0), S3=(0,0,Altura);
dot(S3, 3bp+black);
dot(S4, 3bp+black);
draw(S3 -- S4, 2bp+red);

// Las apotemas de las bases
triple A=(0,0,0);
triple B=(point(PoligonoBase1,0)+point(PoligonoBase1,1))/2;
draw(A -- B, 2bp+red);
triple A=Altura*Z;
triple B=(point(PoligonoBase2,0)+point(PoligonoBase2,1))/2;
draw(A -- B, 2bp+red);

// El trapecio
draw(surface(S1 -- S2 -- S3 -- S4 -- cycle),green);
