//---------------------------------------------------------------
// Fichero:  cono.asy
// Objetivo: Mostrar un cono
// Fecha:    S.9.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// revolution()
import solids;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(0,3cm);

// Punto de proyección
currentprojection = orthographic(50,50,25);

// Datos de la figura
real Radio=4, Altura=7;

// El cono
revolution Cono=cone((0,0,0),Radio,Altura,axis=Z,n=1);
draw(surface(Cono),lightgray+opacity(.5));
draw(Cono,1bp+black);
