//---------------------------------------------------------------
// Fichero:  trapecio.asy
// Objetivo: Mostrar un trapecio con un eje de giro
// Fecha:    S.9.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Datos de la figura plana
real Radio1=3, Radio2=2, Altura=5;

// La figura plana
path Trapecio = (0,0) -- (Radio1,0) -- (Radio2,Altura) -- (0,Altura) -- cycle;
draw(Trapecio,2bp+black);

// El eje
real Extra=.4;
draw((0,-Extra)--(0,Altura+Extra), 2bp+black);

// La flecha del giro
path Flecha=(Extra,Altura)..(0,Altura+2*Extra)..(-Extra,Altura);
draw(shift(0,Extra)*Flecha,1bp+blue,ArcArrow(SimpleHead));
