//---------------------------------------------------------------
// Fichero:  conopequeno.asy
// Objetivo: Mostrar el cono de encima del tronco de cono
// Fecha:    M.12.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// revolution()
import solids;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(4cm);

// Punto de proyección
currentprojection=orthographic((5,2,2),Z);

// Datos de la figura plana que genera el tronco de cono
real Radio1=3, Radio2=2, Altura=2.5;

// Datos auxiliares
real x=Radio2*Altura/(Radio1-Radio2);

// La figura plana que genera el cono
path3 Trapecio = (0,0,Altura) -- (Radio2,0,Altura) -- (0,0,Altura+x);

// El cuerpo de revolución
draw(surface(revolution(Trapecio,Z)),lightgray+opacity(.6));
draw(circle((0,0,0),Radio1),1bp+white);
draw(circle((0,0,Altura),Radio2),1bp+black);
