//---------------------------------------------------------------
// Fichero:  triangulos-2D.asy
// Objetivo: Mostrar en 2D los dos triángulos
// Fecha:    J.7.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,4cm);

// Grosor de las líneas
defaultpen(1);

// Datos de la figura plana que genera el tronco de cono
real Radio1=3, Radio2=2, Altura=2.5;

// Datos auxiliares
real x=Radio2*Altura/(Radio1-Radio2);

// Definición de los vértices
pair A=(0,0), B=(Radio1,0), C=(0,Altura+x);

// El triángulo
draw(A -- B -- C -- cycle);

// La apotema corta
pair D=(0,Altura), E1=(Radio2,Altura);
draw(D -- E1);

// Los textos
pen FormatoTexto=fontsize(8pt)+blue;
label("$h$", (A+D)/2, W, FormatoTexto);
label("$s$", (D+E1)/2, S, FormatoTexto);
label("$h_p$", (D+C)/2, W, FormatoTexto);
label("$r$", (A+B)/2, S, FormatoTexto);

// Marcamos el punto de división
dot(D,2bp+red);

// Marcamos los ángulos rectos
markrightangle(C, A, B, 2mm, 0.5bp+blue);
markrightangle(C, D, E1, 2mm, 0.5bp+blue);
