//---------------------------------------------------------------
// Fichero:  plano.asy
// Objetivo: Mostrar una esfera cortada por un plano
// Fecha:    V.22.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// revolution()
import solids;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(0,3cm);

// Punto de proyección
currentprojection=orthographic(5,4,3);

// La esfera
draw(unitsphere,gray+opacity(.7));

// Un plano que corta a la esfera
real Lado=2.25;
real Altura=0.5;
path3 Plano=shift(-Lado/2,-Lado/2,Altura)*scale3(Lado)*unitsquare3;
draw(surface(Plano),red+opacity(.3));
draw(Plano,0.25bp+red);

// El círculo de corte de la esfera y el plano
draw(surface(circle((0,0,Altura),sqrt(1-Altura^2))),lightred);
draw(circle((0,0,Altura),sqrt(1-Altura^2)),red);
