//---------------------------------------------------------------
// Fichero:  planos.asy
// Objetivo: Mostrar una esfera cortada por dos planos paralelos
// Fecha:    V.22.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// revolution()
import solids;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(0,3cm);

// Punto de proyección
currentprojection=orthographic(5,4,3);

// La esfera
draw(unitsphere,gray+opacity(.7));

// Dos planos paralelos que cortan a la esfera
real Lado=2.25;
real Altura1=0.5, Altura2=-0.3;
path3 Plano1=shift(-Lado/2,-Lado/2,Altura1)*scale3(Lado)*unitsquare3;
path3 Plano2=shift(-Lado/2,-Lado/2,Altura2)*scale3(Lado)*unitsquare3;
draw(surface(Plano1),red+opacity(.3));
draw(surface(Plano2),red+opacity(.3));
draw(Plano1,0.25bp+red);
draw(Plano2,0.25bp+red);

// Los círculos de corte de la esfera y los planos
draw(surface(circle((0,0,Altura1),sqrt(1-Altura1^2))),lightred);
draw(surface(circle((0,0,Altura2),sqrt(1-Altura2^2))),lightred);
draw(circle((0,0,Altura1),sqrt(1-Altura1^2)),red);
draw(circle((0,0,Altura2),sqrt(1-Altura2^2)),red);
