//---------------------------------------------------------------
// Fichero:  esquema.asy
// Objetivo: Mostrar un esquema de la situación
// Fecha:    V.6.10.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,2.5cm);

// Grosor de las líneas
defaultpen(1);

// Los puntos
pair C=(0,0), P=(4,0), A=(.25,0), T=(.25,0.97), T2=(T.x,-T.y), Z=(1,0);

// El segmento circular
fill(T -- T2 -- arc(C,T2,T) -- cycle, mediumgray);

// Los segmentos
pen FormatoSegmento=0.75bp+deepgreen;
draw(C -- P -- T -- cycle, FormatoSegmento);
draw(P -- T2 -- C, FormatoSegmento);

// La circunferencia
draw(circle(C,1));

// Los puntos
pen FormatoPunto=2bp+red;
dot(C, FormatoPunto);
dot(P, FormatoPunto);
dot(A, FormatoPunto);
dot(T, FormatoPunto);
dot(Z, FormatoPunto);

// Los nombres
pen FormatoTexto=fontsize(8pt)+blue;
label("A", A, SE, FormatoTexto);
label("C", C, W, FormatoTexto);
label("P", P, E, FormatoTexto);
label("T", T, NE, FormatoTexto);
label("Z", Z, NE, FormatoTexto);
label("$r$", (C+T)/2, W, FormatoTexto);
label("$h$", (A+Z)/2, N, FormatoTexto);
label("$d$", (3Z+2P)/5, S, FormatoTexto);
