//---------------------------------------------------------------
// Fichero:  forma2.asy
// Objetivo: Representar la forma ax+b⩾0
// Fecha:    J.5.9.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Dimensiones de los ejes
real Xmin = -5, Xmax = 5, Ymin = -3, Ymax = 4;

// Grosor de las líneas
defaultpen(1);

// Los ejes
draw((0,Ymin) -- (0,Ymax), gray);
draw((Xmin,0) -- (Xmax,0), gray);

// La gráfica
pair A=(-5,-2), B=(5,3.5);
draw(A -- B);

// El punto de corte con el eje de abscisas
pair R=intersectionpoint(A--B,(Xmin,0) -- (Xmax,0));
label("r", R, N, blue);

// La solución
draw(R--(Xmax,0),deepgreen);
dot(R,4bp+deepgreen);
