//---------------------------------------------------------------
// Fichero:  forma3.asy
// Objetivo: Representar la forma ax²+bx+c<0
// Fecha:    D.8.9.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// graph()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.4cm);

// Dimensiones de los ejes
real Xmin = -2.5, Xmax = 2.5, Ymin = -1, Ymax = 1;

// Grosor de las líneas
defaultpen(1);

// Los ejes
draw((0,Ymin) -- (0,Ymax), gray);
draw((Xmin,0) -- (Xmax,0), gray);

// La gráfica
real F(real x) { return (0.25*x^2-0.01*x-0.75); }
path Grafica=graph(F,Xmin,Xmax,n=100);
draw(Grafica);

// Los puntos de corte con el eje de abscisas
pair R=(-1.71,0), S=(1.75,0);
label("r", R, N, blue);
label("s", S, N, blue);

// La solución
draw(S--R,deepgreen);
dot(R,4bp+deepgreen);
dot(R,2bp+white);
dot(S,4bp+deepgreen);
dot(S,2bp+white);
