//---------------------------------------------------------------
// Fichero:  representacion.asy
// Objetivo: Mostrar la representación gráfica
// Fecha:    D.8.9.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// grid()
import math;

// fontsize()
import fontsize;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,4cm);

// Dimensiones de los ejes
real Xmin = -3, Xmax = 5, Ymin = -4, Ymax = 5, Extra = 0.5;

// Rejilla de ayuda
add(shift(Xmin,Ymin)*grid((int)(Xmax-Xmin),(int)(Ymax-Ymin),0.3bp+gray));

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(4pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra), gray);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0), gray);

// La gráfica
real F(real x) { return (x^2-2*x-3); }
path Grafica=graph(F,-2.1,4.1,n=200);
draw(Grafica);

// La solución
pair R=(-1,0), S=(3,0);
draw(S--(Xmax+Extra,0),deepgreen);
draw((Xmin-Extra,0)--R,deepgreen);
dot(R,4bp+deepgreen);
dot(S,4bp+deepgreen);
