//---------------------------------------------------------------
// Fichero:  sinsolucionpos.asy
// Objetivo: Representar el caso ax²+bx+c=0 sin solución con a>0
// Fecha:    L.9.9.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// graph()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,1.5cm);

// Dimensiones de los ejes
real Xmin = -2.5, Xmax = 2.5, Ymin = -0.25, Ymax = 2;

// Grosor de las líneas
defaultpen(1);

// Los ejes
draw((0,Ymin) -- (0,Ymax), gray);
draw((Xmin,0) -- (Xmax,0), gray);

// La gráfica
real F(real x) { return (0.25*x^2-0.01*x+0.5); }
path Grafica=graph(F,Xmin,Xmax,n=100);
draw(Grafica);
