//---------------------------------------------------------------
// Fichero:  unasolucionpos.asy
// Objetivo: Representar el caso ax²+bx+c=0 una solución con a>0
// Fecha:    L.9.9.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// graph()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,1.5cm);

// Dimensiones de los ejes
real Xmin = -1, Xmax = 3, Ymin = -0.25, Ymax = 1;

// Grosor de las líneas
defaultpen(1);

// Los ejes
draw((0,Ymin) -- (0,Ymax), gray);
draw((Xmin,0) -- (Xmax,0), gray);

// La gráfica
real F(real x) { return (0.25*(x-1)^2); }
path Grafica=graph(F,Xmin,Xmax,n=100);
draw(Grafica);

// El punto de corte con el eje de abscisas
pair R=(1,0);
dot (R,3bp+blue);
label("r", R, N, blue);
