//---------------------------------------------------------------
// Fichero:  solucion.asy
// Objetivo: Mostrar la gráfica
// Fecha:    X.5.2.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Dimensiones de los ejes
real Xmin = -3, Xmax = 4, Ymin = -1, Ymax = 3, Extra = 0.25;

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(8pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra), gray);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0), gray);

// La gráfica
draw((-3,2) -- (-1,0));
draw((2,1) -- (4,1));
real F(real x) { return (x^2-2x); }
path Grafica=graph(F,-1,2,n=100);
draw(Grafica);

// Los puntos especiales
dot((-3,2), 5bp+black);
dot((-1,0), 5bp+black);
dot((-1,3), 5bp+black);
dot((-1,3), 3bp+white);
dot((2,0), 5bp+black);
dot((2,0), 3bp+white);
dot((2,1), 5bp+black);
