//---------------------------------------------------------------
// Fichero:  exponencial.asy
// Objetivo: Representar la gráfica de la función exponencial
// Fecha:    L.7.10.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// xaxis(), yaxis(), graph()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Grosor de las líneas
defaultpen(0.75);

// Dimensiones de los ejes
real Xmin = -2, Xmax = 2, Ymin = 0, Ymax = 8, Extra = 0.25;

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=gray);

// Formato de texto de los dos ejes
pen FormatoTexto = black+fontsize(4pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra), black);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0), black);

// La gráfica
real F(real x) { return (exp(x)); }
path Grafica=graph(F,Xmin,Xmax,n=100);
draw(Grafica,linewidth(1bp)+blue);
