//---------------------------------------------------------------
// Fichero:  inyectiva.asy
// Objetivo: Mostrar lo que ocurre con una función inyectiva
// Fecha:    X.9.10.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// graph()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Dimensiones de los ejes
real Xmin = -7, Xmax = 7, Ymin = 0, Ymax = 4, Extra = 0.25;

// Grosor de las líneas
defaultpen(1);

// Formato de texto
pen FormatoTexto = blue+fontsize(4pt);

// El eje de ordenadas
draw((0,Ymin-Extra) -- (0,Ymax+Extra), black);

// El eje de abscisas
draw((Xmin-Extra,0) -- (Xmax+Extra,0), black);

// Una recta horizontal
draw ((Xmin,2) -- (Xmax,2), heavygreen);

// La gráfica
real F(real x) { return (1.2^x); }
path Grafica=graph(F,Xmin,Xmax,n=100);
draw(Grafica,linewidth(2bp)+blue);

// El punto de corte
dot((3.8,2),red+4pt);

// El punto del eje de ordenadas
dot((0,2),deepgreen+4pt);
dot((0,2),white+2pt);

// El punto del eje de abscisas
dot((3.8,0),magenta+4pt);

// La flecha
draw((3.8,1.8) -- (3.8,0.2), gray, Arrow(HookHead,1.5bp));
