//---------------------------------------------------------------
// Fichero:  cuadraticaNeg.asy
// Objetivo: Función cuadrática con a<0
// Fecha:    J.19.9.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// graph()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3cm);

// Dimensiones de los ejes
real Xmin = -1, Xmax = 3, Ymin = -1.5, Ymax = 1.8;

// Grosor de las líneas
defaultpen(1);

// La línea del vértice
pen Punteado = linetype(new real[] {2,2});
draw((0,1) -- (Xmax,1), Punteado+gray+1bp);

// El eje de ordenadas
draw((0,Ymin) -- (0,Ymax), gray);

// El eje de abscisas
draw((Xmin,0) -- (Xmax,0), gray);

// La gráfica
real F(real x) { return (-0.5*(x-0.75)^2+1); }
path Grafica=graph(F,Xmin,Xmax,n=200);
draw(Grafica);

// La imagen de la función
draw ((0,Ymin)--(0,1),deepgreen);
dot((0,1),deepgreen+3bp);
label("m",(0,1),W,black+fontsize(8pt));

