//---------------------------------------------------------------
// Fichero:  enunciado.asy
// Objetivo: Espacio para representar las gráficas de log3(x) y 3^x
// Fecha:    J.12.12.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(12cm);

// Dimensiones de los ejes
real Xmin = -1.5, Xmax = 9.5, Ymin = -1.5, Ymax = 9.5;

// Grosor de las líneas
defaultpen(1);

// El eje de ordenadas
draw((0,Ymin) -- (0,Ymax), black);

// El eje de abscisas
draw((Xmin,0) -- (Xmax,0), black);

// Algunas abscisas y ordenadas
real AO[]={-1, 1, 2, 3, 4, 5, 6, 7, 8, 9};
real Desp=0.1;
for ( int i=0 ; i<AO.length ; ++i )
    {
    // Abscisas
    draw((AO[i],-Desp)--(AO[i],Desp),gray);
    label(string(AO[i]),(AO[i],0),2S);

    // Ordenadas
    draw((-Desp,AO[i])--(Desp,AO[i]),gray);
    label(string(AO[i]),(0,AO[i]),2W);
    }

// La bisectriz
pen Punteado = linetype(new real[] {2,2});
draw((-1,-1) -- (9.2,9.2), Punteado+gray);
