//---------------------------------------------------------------
// Fichero:  hexagonal.asy
// Objetivo: Representar un tablero hexagonal
// Fecha:    V.15.3.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Grosor de las líneas
defaultpen(1);

// El hexágono regular básico
path Hexagono=rotate(30)*polygon(6);

// Desplazamientos
real DespHor=sqrt(3);
real DespVer=1.5;

// Repetimos el hexágono
for ( int Fil=-4 ; Fil<5 ; ++Fil )
    {
    for ( int Col=-4 ; Col<5-abs(Fil) ; ++Col )
        {
        real Avance=(Col+quotient(abs(Fil),2))*DespHor+(Fil%2)*DespHor/2;
        draw(shift(Avance,Fil*DespVer)*Hexagono);
        }
    }

// Resaltamos algunos hexágonos
Hexagono=rotate(30)*Hexagono;
draw(shift(-2*DespHor,-2*DespVer)*scale(DespHor)*Hexagono,blue+1.5bp);
draw(shift(DespHor,2*DespVer)*scale(2*DespHor)*Hexagono,blue+1.5bp);
