//---------------------------------------------------------------
// Fichero:  serieC.asy
// Objetivo: Dar varios ejemplos de baldosa serie C
// Fecha:    L.8.4.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(7.5cm);

// Iniciamos el generador de números aleatorios
srand(2);

// Colores disponibles
pen[] Color={blue, yellow, heavygreen, red, gray, purple};

// Función que baraja el conjunto de colores
void Baraja()
    {
    pen Tmp;
    int j;
    for ( int i=0 ; i<Color.length ; ++i )
        {
        j = floor(unitrand()*Color.length);
        Tmp=Color[i];
        Color[i]=Color[j];
        Color[j]=Tmp;
        }
    }

// El cuadrado base
path Cuadrado=polygon(4);

// Los cuatro triángulos en que se divide
pair P0=point(Cuadrado,0), P1=point(Cuadrado,1);
pair P2=point(Cuadrado,2), P3=point(Cuadrado,3);
path T1=(0,0) -- P0 -- P1 -- cycle;
path T2=(0,0) -- P1 -- P2 -- cycle;
path T3=(0,0) -- P2 -- P3 -- cycle;
path T4=(0,0) -- P3 -- P0 -- cycle;

// Las baldosas
int Base=0;
for ( int i=0 ; i<5 ; ++i )
    {
    Baraja();
    fill(shift(Base,0)*T1,Color[0]);
    fill(shift(Base,0)*T2,Color[1]);
    fill(shift(Base,0)*T3,Color[2]);
    fill(shift(Base,0)*T4,Color[3]);
    draw(shift(Base,0)*Cuadrado,black+1bp);
    Base += 2;
    }
