//---------------------------------------------------------------
// Fichero:  cuadrado.asy
// Objetivo: Dar un ejemplo de cuadrado descompuesto
// Fecha:    X.10.4.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(2.5cm);

// Colores disponibles
pen[] Color={blue, yellow, heavygreen, red};

// El cuadrado base
path Cuadrado=polygon(4);

// Los cuatro triángulos en que se divide
pair P0=point(Cuadrado,0), P1=point(Cuadrado,1);
pair P2=point(Cuadrado,2), P3=point(Cuadrado,3);
path T1=(0,0) -- P0 -- P1 -- cycle;
path T2=(0,0) -- P1 -- P2 -- cycle;
path T3=(0,0) -- P2 -- P3 -- cycle;
path T4=(0,0) -- P3 -- P0 -- cycle;

// Dibujamos
fill(T1,Color[0]);
fill(T2,Color[1]);
fill(T3,Color[2]);
fill(T4,Color[3]);
draw(Cuadrado,black+1bp);
