//---------------------------------------------------------------
// Fichero:  dominohexagonal.asy
// Objetivo: Dar varios ejemplos de pieza de dominó hexagonal
// Fecha:    M.2.4.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(17cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve un color aleatorio
pen Color()
    {
    pen[] Posible={blue, yellow, heavygreen, red, purple, cyan, orange, magenta};
    return Posible[floor(Posible.length*unitrand())];
    }

// El hexágono base
path Hexagono=polygon(6);
pair Centro=(0,0);

// Los tres rombos
path R1=Centro--point(Hexagono,0)--point(Hexagono,1)--point(Hexagono,2)--cycle;
path R2=Centro--point(Hexagono,2)--point(Hexagono,3)--point(Hexagono,4)--cycle;
path R3=Centro--point(Hexagono,4)--point(Hexagono,5)--point(Hexagono,0)--cycle;

// Iniciamos el generador de números aleatorios
srand(1);

// Las piezas
real Base=0;
for ( int i=0 ; i<10 ; ++i )
    {
    Base += 2.5;
    // Los hexagonos
    filldraw(shift((Base,0))*R1,Color(),black);
    filldraw(shift((Base,0))*R2,Color(),black);
    filldraw(shift((Base,0))*R3,Color(),black);
    }
