//---------------------------------------------------------------
// Fichero:  colocacion.asy
// Objetivo: Colocar 30 alumnos y alumnas
// Fecha:    J.11.4.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(9cm);

// Grosor de las líneas
defaultpen(1);

// La mesa es un cuadrado
path Mesa=polygon(4);
pair Centro=(point(Mesa,0)+point(Mesa,2))/2;

// Iniciamos el generador de números aleatorios
srand(1);

// Los números de los alumnos y alumnas
int Num[];
for ( int i=0 ; i<30 ; ++i )
    { Num[i] = i+1; }

// Los barajamos
int Tmp, j;
for ( int i=0 ; i<30 ; ++i )
    {
    j = floor(unitrand()*30);
    Tmp=Num[i];
    Num[i]=Num[j];
    Num[j]=Tmp;
    }

// Las mesas
real BaseX=0, BaseY=0;
for ( int i=0 ; i<3 ; ++i )
    {
    BaseX = 0;
    for ( int j=0 ; j<5 ; ++j )
        {
        // Los dos mesas de la pareja
        draw(shift((BaseX+j,BaseY+i))*Mesa,black);
        label(string(Num[10i+2j]),shift((BaseX+j,BaseY+i))*Centro);
        draw(shift((BaseX+j+1.7,BaseY+i))*Mesa,black);
        label(string(Num[10i+2j+1]),shift((BaseX+j+1.7,BaseY+i))*Centro);
        BaseX += 3.2;
        }
    BaseY += 1.3;
    }
