//---------------------------------------------------------------
// Fichero:  octogono.asy
// Objetivo: Mostrar maneras de emparejar vértices
// Fecha:    J.11.4.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(17cm);

// Grosor de las líneas
defaultpen(1);

// Iniciamos el generador de números aleatorios
srand(1);

// Los números de los vértices
int Num[];
for ( int i=0 ; i<8 ; ++i )
    { Num[i] = i; }

// Función que baraja el conjunto de números
void Baraja()
    {
    int Tmp, j;
    for ( int i=0 ; i<8 ; ++i )
        {
        j = floor(unitrand()*8);
        Tmp=Num[i];
        Num[i]=Num[j];
        Num[j]=Tmp;
        }
    }

// El octógono
path Octogono=polygon(8);

// El desplazamiento
real Desp=2.5;

// Las repeticiones
for ( int i=0 ; i<6 ; ++i )
    {
    // Barajamos los vértices
    Baraja();

    // El octógono
    draw(shift(Desp*i)*Octogono,heavygray);

    // Los segmentos
    for ( int j=0 ; j<4 ; ++j )
        {
        draw(shift(Desp*i)*(point(Octogono,Num[2j])--point(Octogono,Num[2j+1])),
             blue+3bp);
        }

   // Los vértices
   for ( int j=0 ; j<8 ; ++j )
       { dot(shift(Desp*i)*point(Octogono,j),red+4bp); }
    }
