//---------------------------------------------------------------
// Fichero:  r6mas.asy
// Objetivo: Dibujar R(6) con más vértices
// Fecha:    L.15.4.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(2.5cm);

// Grosor de las líneas
defaultpen(1);

// El círculo
draw(unitcircle);

// Los ángulos que determinan los puntos
int Ang[] = {-10,70,140,190,240,-50};

// Las cuerdas
path [] Cuerda;
path Tmp;
for ( int i=0 ; i<5 ; ++i ) {
for ( int j=i+1 ; j<6 ; ++j )
    {
    Tmp=dir(Ang[i])--dir(Ang[j]);
    draw(Tmp,1.25bp+heavygreen);
    Cuerda.append(Tmp);
    }}

// Los puntos de intersección
for ( int i=0 ; i<Cuerda.length-1 ; ++i ) {
for ( int j=i+1 ; j<Cuerda.length ; ++j )
    {
    real[][] PosCorte=intersections(Cuerda[i],Cuerda[j]);
    if ( PosCorte.length > 0 )
        {
        pair Corte=intersectionpoint(Cuerda[i],Cuerda[j]);
        dot(Corte,2bp+red);
        }
    }}
