//---------------------------------------------------------------
// Fichero:  partes.asy
// Objetivo: Dar un ejemplo de partes de un conjunto
// Fecha:    J.16.10.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(18cm);

// Función que dibuja un conjunto
void Conjunto(string Elementos, pair Pos)
    {
    transform M = shift(Pos);
    path C=scale(0.6)*unitcircle;
    string E[] = split(Elementos);
    if (E[0]=='1') { fill(M*shift(dir(135))*C, red); }
    if (E[1]=='1') { fill(M*shift(dir(45))*C, deepgreen); }
    if (E[2]=='1') { fill(M*shift(dir(225))*C, blue); }
    if (E[3]=='1') { fill(M*shift(dir(-45))*C, orange); }
    path C=scale(2)*unitcircle;
    draw(M*C,2bp+black);
    }

// El conjunto
Conjunto('1 1 1 1',(0,0));

// Las partes
Conjunto('0 0 0 0',(10,2.25));
Conjunto('1 1 1 1',(10,-2.25));
Conjunto('1 0 0 0',(15,2.25));
Conjunto('0 1 1 1',(15,-2.25));
Conjunto('0 1 0 0',(20,2.25));
Conjunto('1 0 1 1',(20,-2.25));
Conjunto('0 0 1 0',(25,2.25));
Conjunto('1 1 0 1',(25,-2.25));
Conjunto('0 0 0 1',(30,2.25));
Conjunto('1 1 1 0',(30,-2.25));
Conjunto('1 1 0 0',(35,2.25));
Conjunto('0 0 1 1',(35,-2.25));
Conjunto('1 0 1 0',(40,2.25));
Conjunto('0 1 0 1',(40,-2.25));
Conjunto('1 0 0 1',(45,2.25));
Conjunto('0 1 1 0',(45,-2.25));

// La caja
draw(box((7.5,-4.75),(47.5,4.75)),2bp+gray);

// Los textos
pen FT=Helvetica(series="m",shape="n")+fontsize(18pt);
label("A",(0,3.5),FT);
label("P(A)",(27.5,6),FT);
label("$\Rightarrow$",(4.5,0),fontsize(24pt));
