//---------------------------------------------------------------
// Fichero:  explicacion.asy
// Objetivo: Esplicar las siete posibilidades
// Fecha:    J.14.3.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,2cm);

// Grosor de las líneas
defaultpen(0.25);

// Función que dibuja un tablero a partir de un punto
void Tablero(int Base)
    {
    for ( int i=0 ; i<8 ; ++i )
        {
        for ( int j=0 ; j<8 ; ++j  )
            {
            pen Color;
            if ( (i+j)%2 == 1 )
                { Color=white; }
            else
                { Color=mediumgray; }
            filldraw(box((Base+i,j),(Base+i+1,j+1)),Color,black);
            }
        }
    draw(box((Base,0),(Base+8,8)),black+1bp);
    }

// Los tableros
for ( int k=0 ; k<7 ; ++k )
    {
    Tablero(9*k);
    draw(box((10*k,0),(10*k+2,2)),blue+1.25bp);
    dot((10*k+0.5,0.5),red+3bp);
    }
