//---------------------------------------------------------------
// Fichero:  esquema.asy
// Objetivo: Dar un esquema de variaciones, permutaciones y combinaciones
// Fecha:    X.20.3.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Organigramas
import flowchart;

// Unicode
import unicode;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(18cm);

// Grosor de las líneas
defaultpen(1);

// Formato de texto
pen Formato=black+fontsize(10pt);

// Definción de los bloques
string TextoOrden = "$\begin{tabular}{c} ¿Importa \\ el orden?\end{tabular}$";
block Orden=bevel(Label(TextoOrden,Formato),(0,0),white,blue);

string TextoTodos = "$\begin{tabular}{c}¿Intervienen\\todos los\\elementos?\end{tabular}$";
block Todos=bevel(Label(TextoTodos,Formato),(10,5),white,blue);

string TextoRep ="$\begin{tabular}{c}¿Se repiten los\\elementos?\end{tabular}$";
block Rep1=bevel(Label(TextoRep,Formato),(20,9),white,blue);
block Rep2=bevel(Label(TextoRep,Formato),(20,2),white,blue);
block Rep3=bevel(Label(TextoRep,Formato),(20,-5),white,blue);

block Var=rectangle(Label("Variaciones",Formato),(30,11),white,deepgreen);

string TextoVarRep="$\begin{tabular}{c}Variaciones\\con repetición\end{tabular}$";
block VarRep=rectangle(Label(TextoVarRep,Formato),(30,7),white,deepgreen);

block Per=rectangle(Label("Permutaciones",Formato),(30,4),white,deepgreen);

string TextoPerRep="$\begin{tabular}{c}Permutaciones\\con repetición\end{tabular}$";
block PerRep=rectangle(Label(TextoPerRep,Formato),(30,0),white,deepgreen);

block Comb=rectangle(Label("Combinaciones",Formato),(30,-3),white,deepgreen);

string TextoCombRep="$\begin{tabular}{c}Combinaciones\\con repetición\end{tabular}$";
block CombRep=rectangle(Label(TextoCombRep,Formato),(30,-7),white,deepgreen);

// Dibujamos los bloques
draw(Orden);
draw(Todos);
draw(Rep1);
draw(Rep2);
draw(Rep3);
draw(Var);
draw(VarRep);
draw(Per);
draw(PerRep);
draw(Comb);
draw(CombRep);

// Las conexiones
add(new void(picture pic, transform t) {
    blockconnector operator --=blockconnector(pic,t);

    Orden--Label("Sí",1,NW)--Up--Right--Arrow--Todos;
    Orden--Label("No",1,SW)--Down--Right--Arrow--Rep3;
    Todos--Label("No",1,NW)--Up--Right--Arrow--Rep1;
    Todos--Label("Sí",1,SW)--Down--Right--Arrow--Rep2;
    Rep1--Label("No",1,NW)--Up--Right--Arrow--Var;
    Rep1--Label("Sí",1,SW)--Down--Right--Arrow--VarRep;
    Rep2--Label("No",1,NW)--Up--Right--Arrow--Per;
    Rep2--Label("Sí",1,SW)--Down--Right--Arrow--PerRep;
    Rep3--Label("No",1,NW)--Up--Right--Arrow--Comb;
    Rep3--Label("Sí",1,SW)--Down--Right--Arrow--CombRep;
    });
