//---------------------------------------------------------------
// Fichero:  solucion6.asy
// Objetivo: Representar la solución 6
// Fecha:    L.12.2.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8.8cm);

// Grosor de las líneas
defaultpen(1);

// Función que marca un punto
void Marca(real Num, string Tex, pen Color)
    {
    dot((Num,0),4bp+Color);
    label(Tex,(Num,0),S);
    }

// Datos de este problema
int Izq=-8, Der=-7, Num=1, Den=6;
real Alt=0.5;

// El eje de abscisas
draw((Izq-0.05,0) -- (Der+0.05,0));

// La semirrecta
int Ini, Fin;
real Valor=Num/Den;
string TextoIzq=string(abs(Izq));
string TextoDer=string(abs(Der));
if ( Izq>0 )
    {
    Ini=Izq;
    Fin=Der;
    }
else
    {
    Ini=Der;
    Fin=Izq;
    Valor=-Valor;
    TextoIzq="$-$"+TextoIzq;
    TextoDer="$-$"+TextoDer;
    }
draw((Ini,0) -- (Fin,Alt));

// Arcos
real Ang=aTan(Alt);
if ( Izq<0 ) { Ang = 180-Ang; }
real Paso = 0.9/Den;
for ( int i=1 ; i<Den+1 ; ++i )
    { draw(arc((Ini,0),i*Paso,Ang+5/i,Ang-5/i),gray); }

// Líneas auxiliares
draw((Fin,0)--(Ini,0)+0.9*dir(Ang),magenta);
draw((Ini+Valor,0)--(Ini,0)+Num*Paso*dir(Ang),magenta);

// Los puntos
Marca(Izq,TextoIzq,blue);
Marca(Der,TextoDer,blue);
Num += abs(Ini)*Den;
string Texto = string(Num)+"}{"+string(Den);
Texto = "\frac{"+Texto+"}";
if ( Izq<0 ) { Texto = "-"+Texto; }
Marca(Ini+Valor,"$"+Texto+"$",deepgreen);
