//---------------------------------------------------------------
// Fichero:  solucion2.asy
// Objetivo: Representar la solución 2
// Fecha:    M.13.2.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8.8cm);

// Grosor de las líneas
defaultpen(1);

// La raíz
real Raiz=sqrt(3);

// Las coordenadas
real Abs=sqrt(2), Ord=1;

// Los ejes de coordenadas
draw((0,0) -- (Raiz+0.2,0));
draw((0,0) -- (0,Ord+0.1));

// El ángulo recto
markrightangle((Abs,Ord), (Abs,0), (0,0), 3mm, 0.5bp+gray);

// Líneas auxiliares
draw((0,0)--(Abs,Ord),gray);
draw((Abs,0)--(Abs,Ord),gray);
draw((0,Ord)--(Abs,Ord),gray);
draw(arc((0,0),Raiz,0,aTan(Ord/Abs)+5),magenta);

// Los puntos
dot((0,0),3bp+black); label("0",(0,0),S);
dot((Abs,Ord),3bp+black);
pair A=(Abs,0); dot(A,4bp+blue); label("$\sqrt{2}$",A,S);
pair B=(0,Ord); dot(B,4bp+blue); label(string(Ord),B,W);
pair C=(Raiz,0); dot(C,4bp+deepgreen); label("$\sqrt{3}$",C,S);

// Puntos auxiliares
for (int i=1 ; i<Abs ; ++i)
    {
    dot((i,0),3bp+blue);
    label(string(i),(i,0),S);
    }

// Longitud de la hipotenusa
label("$\sqrt{3}$",(A+B)/2,NW);
