//---------------------------------------------------------------
// Fichero:  dibujo.asy
// Objetivo: Dibujar un triángulo rectángulo de catetos 1 y 1
// Fecha:    D.28.1.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(1,0), C=(0,1);

// El ángulo
markrightangle(B, A, C, 3mm, 0.5bp+gray);

// El triangulo
draw(A -- B -- C -- cycle);

// Los nombres
label("$\sqrt 2$", (B+C)/2, NE);
label("$1$", (A+B)/2, S);
label("$1$", (A+C)/2, W);
