//---------------------------------------------------------------
// Fichero:  resolucion1.asy
// Objetivo: Representar la resolución 1
// Fecha:    X.7.2.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Función que marca un punto
void Marca(real Num, string Tex, pen Color)
    {
    dot((Num,0),4bp+Color);
    label(Tex,(Num,0),S);
    }

// El eje de abscisas
draw((3.95,0) -- (5.05,0));

// La semirrecta
draw((4,0) -- (5,0.15));

// Arcos
real alfa=aTan(0.15);
for ( int i=1 ; i<4 ; ++i )
    {
    draw(arc((4,0),i*0.3,alfa+3/i,alfa-3/i),gray);
    label('('+string(i)+')',(4,0)+i*0.3*dir(alfa+3/i),N,fontsize(8pt));
    }

// Líneas auxiliares
draw((5,0)--(4,0)+0.9*dir(alfa),magenta);
draw((4.67,0)--(4,0)+0.6*dir(alfa),magenta);

// Los puntos
Marca(4,"$4$",blue);
Marca(5,"$5$",blue);
Marca(4.67,"$\frac{14}{3}$",deepgreen);
