//---------------------------------------------------------------
// Fichero:  resolucion1.asy
// Objetivo: Representar la resolución 1
// Fecha:    S.17.2.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8.8cm);

// Grosor de las líneas
defaultpen(1);

// La elipse general
path Elipse=scale(4,3)*unitcircle;

// Formato del texto
pen Formato=fontsize(18pt)+Bookman(series="b",shape="n");

// Los conjuntos
real Sep=3.5;
draw(shift(-Sep/2,0)*Elipse);
draw(shift(Sep/2,0)*Elipse);
label("A",(-4.8,2.3),NW,Formato);
label("B",(4.8,2.3),NE,Formato);

// Los elementos
label("c",(-3.5,1.3),Formato);
label("d",(-3.5,-1.3),Formato);
label("e",(0,1.3),Formato);
label("f",(0,-1.3),Formato);
label("g",(3.5,1.3),Formato);
label("h",(3.5,-1.3),Formato);
