//---------------------------------------------------------------
// Fichero:  resolucion2.asy
// Objetivo: Representar la resolución 2
// Fecha:    S.17.2.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8.8cm);

// Grosor de las líneas
defaultpen(1);

// La elipse general
path Elipse=scale(4,4)*unitcircle;

// Formato del texto
pen Formato=fontsize(18pt)+Bookman(series="b",shape="n");

// Los conjuntos
real Sep=9;
draw(shift(-Sep/2,0)*Elipse);
draw(shift(Sep/2,0)*Elipse);
label("A",(-7.8,2.4),NW,Formato);
label("B",(7.8,2.4),NE,Formato);

// Los elementos
label("c",(-6.3,1.5),Formato);
label("e",(-6.3,-1.5),Formato);
label("d",(-3,1.5),Formato);
label("f",(-3,-1.5),Formato);
label("g",(3.1,1.5),Formato);
label("i",(3.1,-1.5),Formato);
label("h",(6.3,1.5),Formato);
label("j",(6.3,-1.5),Formato);
